<?php

include_once dirname(__FILE__).'/admin_functions.php';

if (isset($_POST['company'])) {
	
	$company_data = $_POST['company'];
	
	save_company($company_data);
	
	header("Location: index.php");
	
} else {
	// show form
	if ($_REQUEST['a'] == 'edit_company') {
		
		$link = get_mysql_connection();
		
		$data = get_company_data($link, $_REQUEST['id']);
		
		close_mysql_connection($link);
	} else {
		
		$data = array(
			'company_name' => '',
			'url' => '',
			'realm_id' => '',
			'user_external_token' => '',
			'is_active' => '1',
		);
		
	}
	
	
?>
<!doctype html>
<html lang="en" class="h-100">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <title>EVX - Quickbooks integration settings</title>

    

    <!-- Bootstrap core CSS -->
<link href="css/bootstrap/bootstrap.min.css" rel="stylesheet">

    <style>
      .bd-placeholder-img {
        font-size: 1.125rem;
        text-anchor: middle;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
      }

      @media (min-width: 768px) {
        .bd-placeholder-img-lg {
          font-size: 3.5rem;
        }
      }
    </style>

    <link rel="shortcut icon" href="favicon.ico">
    
    <!-- Custom styles for this template -->
    <link href="css/admin.css" rel="stylesheet">
    
    <script src="js/bootstrap/bootstrap.bundle.min.js"></script>
    
    <script src="js/jquery/jquery-3.5.1.min.js"></script>
    
  </head>
  <body class="d-flex flex-column h-100">
    
<header>
  <!-- Fixed navbar -->
  <nav class="navbar navbar-expand-md navbar-dark fixed-top bg-dark">
    <div class="container-fluid">
      Register company
    </div>
  </nav>
</header>

<!-- Begin page content -->
<main class="flex-shrink-0">
  <div class="container title">
    <h1 class="mt-5">Register company</h1>
  </div>
  <div class="container">
  	<form action="company_form.php" method="post">
  	
  		<input type="hidden" id="input_id" name="company[id]" value="<?php if (isset($data['id'])) echo $data['id']; ?>" />
  	
	  <div class="form-group">
	    <label for="input_name">Company name</label>
	    <input type="text" class="form-control" id="input_name" name="company[company_name]" value="<?php echo $data['company_name']?>" aria-describedby="name_help">
	    <small id="name_help" class="form-text text-muted">Name that identifies the company.</small>
	  </div>
	  
	  <div class="form-group">
	    <label for="input_url">EVX url</label>
	    <input type="text" class="form-control" id="input_url" name="company[url]" value="<?php echo $data['url']?>" aria-describedby="url_help">
	    <small id="url_help" class="form-text text-muted">URL of the EVX account.</small>
	  </div>
	  
	  <div class="form-group">
	    <label for="input_realm_id">Quickbooks Id</label>
	    <input type="text" class="form-control" id="input_realm_id" name="company[realm_id]" value="<?php echo $data['realm_id']?>" aria-describedby="realm_id_help">
	    <small id="realm_id_help" class="form-text text-muted">Company Id inside Quickbooks, it can be obtaned in Settings -> Billing and subscriptions.</small>
	  </div>
	  
	  <div class="form-group">
	    <label for="input_user_external_token">EVX user token</label>
	    <input type="text" class="form-control" id="input_user_external_token" name="company[user_external_token]" value="<?php echo $data['user_external_token']?>" aria-describedby="user_external_token_help">
	    <small id="user_external_token_help" class="form-text text-muted">External token of any EVX user that with permissions for invoices and payments, it can be generated in Account -> Manage external tokens.</small>
	  </div>
	  
	  <div class="form-group">
		<label for="input_is_active">Active</label>
	    <select class="form-control" id="input_is_active" name="company[is_active]">
	      <option value="0" <?php echo ($data['is_active'] == 0 ? 'selected="selected"' : '') ?>>No</option>
	      <option value="1" <?php echo ($data['is_active'] == 1 ? 'selected="selected"' : '') ?>>Yes</option>
	    </select>
	    <small id="is_active_help" class="form-text text-muted">This field is used to enable or disable the synchronization for this company.</small>
	  </div>
	  <button type="submit" class="btn btn-primary">Register</button>
	  <button type="button" class="btn btn-secondary" onclick="window.history.back();">Cancel</button>
	</form>
  </div>
</main>

<footer class="footer mt-auto py-3 bg-light">
  <div class="container">
    <span class="text-muted">EVX Software</span>
  </div>
</footer>

      
  </body>
</html>
<?php 
	
}