<?php

include_once dirname(__FILE__).'/admin_functions.php';

$companies = get_all_registered_companies();

?>
<!doctype html>
<html lang="en" class="h-100">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <title>EVX - Quickbooks integration settings</title>

    

    <!-- Bootstrap core CSS -->
<link href="css/bootstrap/bootstrap.min.css" rel="stylesheet">

    <style>
      .bd-placeholder-img {
        font-size: 1.125rem;
        text-anchor: middle;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
      }

      @media (min-width: 768px) {
        .bd-placeholder-img-lg {
          font-size: 3.5rem;
        }
      }
    </style>

    <link rel="shortcut icon" href="favicon.ico">
    
    <!-- Custom styles for this template -->
    <link href="css/admin.css" rel="stylesheet">
    
    <script src="js/bootstrap/bootstrap.bundle.min.js"></script>
    
    <script src="js/jquery/jquery-3.5.1.min.js"></script>
    
  </head>
  <body class="d-flex flex-column h-100">
    
<header>
  <!-- Fixed navbar -->
  <nav class="navbar navbar-expand-md navbar-dark fixed-top bg-dark">
    <div class="container-fluid">
      EVX Software - Quickbooks online integration settings
    </div>
  </nav>
</header>

<!-- Begin page content -->
<main class="flex-shrink-0">
  <div class="container title">
    <h1 class="mt-5">EVX Software - Quickbooks online<br/>Integration settings</h1>
    <p class="lead">Here are the settings for each company that can synchronize data between EVX Software and Quickbooks.</p>
  </div>
  <div class="container">
  	<h2 class="mt-5">Registered Companies</h2>
  	<table class="table">
  		<thead>
  			<tr><th>Name</th><th>EVX url</th><th>Quickbooks Id</th><th>EVX user token</th><th>Status</th><th>Actions</th></tr>
  		</thead>
  		<tbody>
  		<?php foreach ($companies as $company) { ?>
  			<tr>
  				<td><?php echo $company['company_name']?></td>
  				<td><?php echo $company['url']?></td>
  				<td><?php echo $company['realm_id']?></td>
  				<td><?php echo $company['user_external_token']?></td>
  				<td><?php echo $company['is_active'] == 1 ? 'Active' : 'Inactive'?></td>
  				<td>
  					<a href="process_action.php?a=edit_company&id=<?php echo $company['id'] ?>">Edit</a> -
  					
  					<a href="#" data-id="<?php echo $company['id']?>" class="open-delete-dialog">Delete</a>
				</td>
			</tr>
		<?php } ?>
  		</tbody>
  	</table>
  	<a class="btn btn-primary" href="process_action.php?a=new_company" role="button">Register new company</a>
  </div>
	
</main>

<footer class="footer mt-auto py-3 bg-light">
  <div class="container">
    <span class="text-muted">EVX Software</span>
  </div>
</footer>


    
    <script>
	$(".open-delete-dialog").click(function() {

		if (confirm("Are you sure you want to delete this company?")) {
			var comp_id = $(this).data('id');
			if (comp_id > 0) {
				window.location.href = 'process_action.php?a=delete_company&id='+comp_id;
			}
		}
	});
    
    
	</script>

      
  </body>
</html>
