<?php

include_once dirname(__FILE__).'/config.php';

function get_realm_data($link, $realm_id) {
	
	$realm_data = null;
	
	$sql = "SELECT * FROM registered_companies WHERE realm_id='$realm_id' AND is_active=1 LIMIT 1";
	
	$res = @mysqli_query($link, $sql);
	if (!$res) {
		_log("Error getting company information from DB:\n". mysqli_error($link));
		return;
	}
	$realm_data = mysqli_fetch_assoc($res);
	
	mysqli_free_result($res);
	
	return $realm_data;
}

function get_company_data($link, $id) {
	
	$data = null;
	
	$sql = "SELECT * FROM registered_companies WHERE id='$id' LIMIT 1";
	
	$res = @mysqli_query($link, $sql);
	if (!$res) {
		_log("Error getting company information from DB:\n". mysqli_error($link));
		return;
	}
	$data = mysqli_fetch_assoc($res);
	
	mysqli_free_result($res);
	
	return $data;
}

function get_mysql_connection() {
	
	$link =  @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
	if (mysqli_connect_errno()) {
		_log("Failed to connect to MySQL".mysqli_connect_error());
		return false;
	}
	
	return $link;
}

function close_mysql_connection($link) {
	mysqli_close($link);
}


function process_all_data_changes($entities_by_realm_id) {
	
	if (count($entities_by_realm_id) > 0) {
		
		$mysql_link = get_mysql_connection();
		
		foreach ($entities_by_realm_id as $realm_id => $entities) {
			// save the entities that must be procesed
			save_entities_to_update($mysql_link, $realm_id, $entities);
			
			// execute the script that sends the data to the right evx installation
			execute_entity_update_script($mysql_link, $realm_id);
		}
		
		close_mysql_connection($mysql_link);
	}
	
}


function get_entites_to_update($link, $realm_id) {
	
	$sql = "SELECT * FROM updates_to_execute WHERE realm_id='$realm_id'";
	
	$res = @mysqli_query($link, $sql);
	if (!$res) {
		_log("Error getting entities to update in DB:\n". mysqli_error($link));
		return false;
	}
	
	$entities_array = array();
	
	while ($row = mysqli_fetch_assoc($res)) {
		$entities_array = array_merge($entities_array, json_decode($row['json_data'], true));
	}
	
	mysqli_free_result($res);
	
	return $entities_array;
}


function execute_entity_update_script($link, $realm_id) {
	
	$realm_data = get_realm_data($link, $realm_id);
	
	if ($realm_data['url'] != '' && $realm_data['user_external_token'] != '') {
		
		$entities_array = get_entites_to_update($link, $realm_id);
		
		if (count($entities_array) > 0) {
			$entities_json = base64_encode(json_encode($entities_array));
			
			$parameters = array(
					'token' => $realm_data['user_external_token'],
					'entities' => $entities_json,
			);
			
			$url_params = http_build_query($parameters);
			$url_params = str_replace("&", "\\&", $url_params);
			$query_url = $realm_data['url'] . '/qbo_webhook_callback.php?' . $url_params;
			_log($query_url);
			
			$command = "wget -b -o /dev/null $query_url";
			exec("$command > /dev/null &");
			
			// copy procesed entities to the completed entities table
			$sql = "INSERT INTO updates_completed SELECT * FROM updates_to_execute WHERE realm_id='$realm_id'";
			@mysqli_query($link, $sql);
			
			// delete them from current table
			$sql = "DELETE FROM updates_to_execute WHERE realm_id='$realm_id'";
			@mysqli_query($link, $sql);
			
		}
	}
}

function save_entities_to_update($link, $realm_id, $entities) {
	
	if (is_array($entities)) $entities = json_encode($entities);
	
	$realm_id = mysqli_real_escape_string($link, $realm_id);
	$entities = mysqli_real_escape_string($link, $entities);
	
	$sql = "
		INSERT INTO `updates_to_execute` (realm_id, created_on, json_data) VALUES
		('$realm_id', NOW(), '$entities');
	";
	
	$res = @mysqli_query($link, $sql);
	if (!$res) {
		_log("Error saving entities in DB:\n". mysqli_error($link));
		return false;
	}
	
	return true;
}


function _log($msg_object) {
	
	$date_str = date('Y-m-d H:i:s');
	
	$msg_str = is_string($msg_object) ? $msg_object : print_r($msg_object, 1);
	
	file_put_contents(LOG_FILE, "$date_str - $msg_str\n", FILE_APPEND);
	
}


// check JSON
function is_valid_json($string) {
	if (!isset($string) || trim($string) === '') {
		return false;
	}
	
	@json_decode($string);
	if (json_last_error() != JSON_ERROR_NONE) {
		return false;
	}
	return true;
}

