
CREATE TABLE IF NOT EXISTS `registered_companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realm_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `company_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(511) COLLATE utf8_unicode_ci NOT NULL,
  `user_external_token` varchar(511) COLLATE utf8_unicode_ci NOT NULL,
  `last_update_date` datetime NOT NULL,
  `is_active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `realm_id` (`realm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci



CREATE TABLE IF NOT EXISTS `updates_completed` (
  `id` int(10) unsigned NOT NULL,
  `realm_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `json_data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realm_id_created_on` (`realm_id`,`created_on`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


CREATE TABLE IF NOT EXISTS `updates_to_execute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `realm_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created_on` datetime NOT NULL,
  `json_data` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `realm_id_created_on` (`realm_id`,`created_on`),
  CONSTRAINT `updates_to_execute_ibfk_1` FOREIGN KEY (`realm_id`) REFERENCES `registered_companies` (`realm_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
