<?php

include_once dirname(__FILE__).'/functions.php';

// DEVELOPMENT ENVIRONMENT TOKEN
//$webhook_token = "10cf68f8-cb47-4627-b7ff-1a5efc774255";

// PRODUCTION ENVIRONMENT TOKEN
$webhook_token = "436c86b5-072f-423e-b7ed-2693112e4c61";

$allowed_entity_types = array('Invoice', 'Payment');

_log("*** START WEBHOOK PROCESS ***");
if (isset($_SERVER['HTTP_INTUIT_SIGNATURE']) && !empty($_SERVER['HTTP_INTUIT_SIGNATURE'])) {
	
	$payload = file_get_contents("php://input");
	
	if (is_valid_json($payload)) {
		
		$payload_hash = hash_hmac('sha256', $payload, $webhook_token);
		$singature_hash = bin2hex(base64_decode($_SERVER['HTTP_INTUIT_SIGNATURE']));
		
		// Check if hashes are OK
		if($payload_hash == $singature_hash) {
			$payload_data = json_decode($payload, true);
			
			// group received entities by realm
			$entities_by_realm_id = array();
			foreach ($payload_data['eventNotifications'] as $event_notification) {
				// Intuit Company Id
				$realm_id = $event_notification['realmId'];
				
				// Group QBO entity changes by realm id
				foreach($event_notification['dataChangeEvent']['entities'] as $entity) {
					
					// only process the allowed entities
					if (in_array($entity['name'], $allowed_entity_types)) {
						if (!isset($entities_by_realm_id[$realm_id])) $entities_by_realm_id[$realm_id] = array();
						
						$entities_by_realm_id[$realm_id][] = $entity;
					}
				}
			}
			
			// process the changes together for each realm
			process_all_data_changes($entities_by_realm_id);
			
		} else {
			_log("WEBHOOK NOT VERIFIED:\npayLoad:$payload\nSERVER:".print_r($_SERVER,1));
		}
	}
}
_log("*** END WEBHOOK PROCESS ***");

// Respond OK to Quickbooks, so it will not retry sending the same updates
header("HTTP/1.1 200 OK");




